
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
# Sample technology data
fiber_speeds = np.random.normal(loc=150, scale=20, size=1000)
cable_speeds = np.random.normal(loc=90, scale=25, size=1000)

# Compute density for each dataset
density_fiber = gaussian_kde(fiber_speeds)
density_cable = gaussian_kde(cable_speeds)
xs = np.linspace(30, 220, 300)
ys_fiber = density_fiber(xs)
ys_cable = density_cable(xs)

# Labels and texts
labels = ["Fiber", "Cable"]
xlabel = "Download Speed (Mbps)"
ylabel = "Density"
title = "Distribution of Download Speeds for Fiber and Cable Connections"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (30, 220)
grid_style = "--"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Fill between x for density regions
plt.fill_between(xs, ys_fiber, color="orange", alpha=0.4, label=labels[0])
plt.fill_between(xs, ys_cable, color="blue", alpha=0.4, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
plt.grid(True, linestyle=grid_style, linewidth=0.5)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_77.pdf", bbox_inches="tight")
