

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define regions as groups
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Central America",
    "Middle East",
    "Southeast Asia",
    "Scandinavia",
]

# Agriculture data: Crop Production (solid_bar) and Crop Yield (striped_bar)
crop_production = np.random.rand(10) * 50 + 20  # Crop production in metric tons, ranging from 20 to 70 million metric tons
crop_yield = np.random.rand(10) * 5 + 1  # Crop yield in kilograms per hectare, ranging from 1 to 6 thousand kilograms per hectare

# Errors for both metrics
production_errors = np.random.rand(10) * 5 + 1  # Error bars for crop production
yield_errors = np.random.rand(10) * 1 + 0.5  # Error bars for crop yield

# Labels and Plot Types
label_Crop_Production = "Crop Production (Metric Tons)"
label_Crop_Yield = "Crop Yield (Kilograms per Hectare)"

# Axes Limits and Labels
ylabel_value = "Value"
title = "Agricultural Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Create vertical stacked bar chart
ax.bar(
    x,
    crop_production,
    color="#2a9d8f",
    yerr=production_errors,
    label=label_Crop_Production,
    capsize=3,
)
ax.bar(
    x,
    crop_yield,
    bottom=crop_production,
    color="#f4a261",
    yerr=yield_errors,
    label=label_Crop_Yield,
    capsize=3,
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_100.pdf", bbox_inches="tight")
