

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define regions as groups
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Central America",
    "Middle East",
    "Southeast Asia",
    "Scandinavia",
]

# Economic data: GDP Growth Rate (solid_bar) and Inflation Rate (striped_bar)
gdp_growth_rate = (
    np.random.rand(10) * 15 - 5
)  # GDP Growth Rate ranging from -5% to 10%
inflation_rate = (
    np.random.rand(10) * 20
)  # Inflation Rate ranging from 0% to 20%

# Errors for both metrics
gdp_errors = np.random.rand(10) * 2 + 1  # Error bars for GDP Growth Rate
inflation_errors = np.random.rand(10) * 3 + 1  # Error bars for Inflation Rate

# Labels and Plot Types
label_gdp_growth = "GDP Growth Rate"
label_inflation = "Inflation Rate"

# Axes Limits and Labels
ylabel_value = "Economic Metric (%)"
title = "Economic Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Custom colors
color_gdp_growth = "#4CAF50"  # Green
color_inflation = "#A9A9A9"  # Gray

# Create vertical stacked bar chart
ax.bar(
    x,
    gdp_growth_rate,
    color=color_gdp_growth,
    yerr=gdp_errors,
    label=label_gdp_growth,
    capsize=5,
    edgecolor='black'
)
ax.bar(
    x,
    inflation_rate,
    bottom=gdp_growth_rate,
    color=color_inflation,
    yerr=inflation_errors,
    label=label_inflation,
    capsize=5,
    edgecolor='black'
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_101.pdf", bbox_inches="tight")

