

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define regions as groups
regions = [
    "Paris",
    "New York City",
    "Tokyo",
    "Barcelona",
    "Dubai",
    "Rome",
    "Sydney",
    "Bangkok",
    "Istanbul",
    "London",
]

# Education data: Average Test Scores and Average Study Hours per Week
average_test_scores = (
    np.random.rand(10) * 20 + 60
)  # Test scores ranging from 60 to 80
average_study_hours = (
    np.random.rand(10) * 5 + 10
)  # Study hours ranging from 10 to 15 hours per week

# Errors for both metrics
score_errors = np.random.rand(10) * 2 + 1  # Error bars for test scores
study_hours_errors = np.random.rand(10) * 1 + 0.5  # Error bars for study hours

# Labels and Plot Types
label_Average_Test_Scores = "Average Test Scores"
label_Average_Study_Hours = "Average Study Hours per Week"

# Axes Limits and Labels
ylabel_value = "Value"
title = "Education Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Create vertical stacked bar chart
color_test_scores = "#ff9999"  # Light Coral
color_study_hours = "#66b3ff"  # Light Sky Blue

ax.bar(
    x,
    average_test_scores,
    color=color_test_scores,
    yerr=score_errors,
    label=label_Average_Test_Scores,
    capsize=5,
    edgecolor='black'
)
ax.bar(
    x,
    average_study_hours,
    bottom=average_test_scores,
    color=color_study_hours,
    yerr=study_hours_errors,
    label=label_Average_Study_Hours,
    capsize=5,
    edgecolor='black'
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_102.pdf", bbox_inches="tight")

