
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for different philosophical themes
categories = [
    "Existentialism",
    "Stoicism",
    "Nihilism",
    "Absurdism",
    "Utilitarianism",
    "Realism",
    "Idealism",
]
support_scores = [
    75,
    80,
    65,
    70,
    85,
    60,
    55,
]  # Percentage scores for philosophical theme support
criticism_rates = [
    -20,
    -15,
    -25,
    -23,
    -10,
    -28,
    -30,
]  # Negative values for criticism rates

# Error data for each theme
support_errors = [4, 3, 5, 3, 4, 6, 5]
criticism_errors = [3, 2, 4, 3, 2, 5, 4]

# Labels and text for chart
xlabel = 'Philosophical Themes'
ylabel = 'Percentage (%)'
title = 'Public Opinion on Various Philosophical Themes'
textlabels = ["Criticism", "Support"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(12, 8))  # Adjusted size for clarity

# Define colors
support_colors = [
    "#6a0dad",  # Purple
    "#6495ed",  # CornflowerBlue
    "#20b2aa",  # LightSeaGreen
    "#ff6347",  # Tomato
    "#ffd700",  # Gold
    "#dda0dd",  # Plum
    "#90ee90",  # LightGreen
]
criticism_colors = [
    mcolors.to_rgba(color, alpha=0.7) for color in support_colors
]  # Slightly lighter for criticism

# Plot vertical bar charts with error bars
ax.bar(
    categories,
    criticism_rates,
    color=criticism_colors,
    edgecolor="black",
    yerr=criticism_errors,
    capsize=5,
)
ax.bar(
    categories,
    support_scores,
    bottom=0,
    color=support_colors,
    edgecolor="black",
    yerr=support_errors,
    capsize=5,
)

# Adding labels within bars for values
for i, (cri_val, sup_val) in enumerate(zip(criticism_rates, support_scores)):
    ax.text(i, cri_val / 2, f"{abs(cri_val)}%", va="center", ha="center", color="black")
    ax.text(i, sup_val / 2, f"{sup_val}%", va="center", ha="center", color="black")

# Customizing axis and layout
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.tick_params(axis="x", which="both", bottom=False)  # Remove x-axis tick marks

# Draw a horizontal line at y=0 for separation
ax.axhline(0, color="black", linewidth=0.8)

# Adding labels at the ends of y-axis
ax.text(-0.5, -35, textlabels[0], ha="right", va="bottom", rotation="vertical", fontsize=12)
ax.text(-0.5, 35, textlabels[1], ha="right", va="bottom", rotation="vertical", fontsize=12)

# Add grid lines for better readability
ax.grid(True, linestyle='--', alpha=0.7)

# Remove unnecessary spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_111.pdf", bbox_inches="tight")
