# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Finance Data for three companies
metrics = ["Revenue Growth", "Profit Margin", "Expense Ratio"]
values = np.array(
    [
        [15, 25, 12],  # Company A
        [20, 18, 14],  # Company B
        [22, 20, 13],  # Company C
    ]
)

# Asymmetric error values for the finance data
errors = np.array(
    [
        [[2, 1], [3, 2], [2, 1]],  # Errors for Company A (lower, upper)
        [[3, 2], [2, 2], [3, 1]],  # Errors for Company B
        [[2, 1], [3, 2], [2, 1]],  # Errors for Company C
    ]
)

# Creating subplots for each company
companies = ["Company A", "Company B", "Company C"]

ylabel = "Financial Metrics"
ylim = [0, 30]
suptitle = "Financial Performance Metrics by Company"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(1, 3, figsize=(12, 5))  # Enlarged figure layout


# Function to plot each company's data
def plot_company_data(ax, errors, company_index, company_name):
    x = np.arange(len(metrics))  # the label locations
    bar_colors = ["#4daf4a", "#ff7f00", "#377eb8"]
    barerrors = np.array(errors).T[:, :, company_index]
    bars = ax.bar(x, values[company_index], yerr=barerrors, color=bar_colors, capsize=7)
    for bar, lower_error, upper_error in zip(bars, barerrors[0], barerrors[1]):
        # Position for lower error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() - lower_error - 1.5,
            f"-{lower_error}",
            va="bottom",
            ha="center",
            color="black",
        )
        # Position for upper error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() + upper_error + 0.5,
            f"+{upper_error}",
            ha="center",
            color="black",
        )

    ax.set_title(company_name)
    ax.set_xticks(x)
    ax.set_xticklabels(metrics, rotation=45, ha="right")
    ax.set_ylabel(ylabel)
    ax.set_ylim(ylim)  # Uniform scale for all charts


for i, company in enumerate(companies):
    plot_company_data(axs[i], errors, i, company)

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(suptitle, fontsize=16)
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("errorbar_117.pdf", bbox_inches="tight")
