
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data setup
import numpy as np

np.random.seed(0)

# Cities
cities = ["City A", "City B", "City C", "City D"]
x = np.arange(len(cities))  # X-axis points

# Air quality scores for PM2.5 and NO2 levels in different cities
pm25_levels = np.array([55, 60, 52, 58])  # Example levels for PM2.5
no2_levels = np.array([40, 45, 42, 44])  # Example levels for NO2

# Errors for both metrics
pm25_errors = np.array([5, 4, 6, 5])
no2_errors = np.array([3, 4, 3, 2])

labels = ["PM2.5 Levels", "NO2 Levels"]
ylabels = ["PM2.5 (µg/m³)", "NO2 (ppb)"]

title = "Air Quality Levels in Various Cities"
ylims = [[40, 70], [30, 50]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting setup
fig, ax1 = plt.subplots(figsize=(8, 5))

# Bar width and hatch patterns
width = 0.35
hatch_patterns = ["//", "oo"]

# Colors for the bars
colors = ["#4CAF50", "#FF9800"]  # Green and Orange

# Plot data on the left y-axis (PM2.5 levels)
ax1.bar(
    x,
    pm25_levels,
    width,
    color=colors[0],
    hatch=hatch_patterns[0],
    label=labels[0],
    yerr=pm25_errors,
    capsize=5,
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis (NO2 levels)
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    no2_levels,
    width,
    color=colors[1],
    hatch=hatch_patterns[1],
    label=labels[1],
    yerr=no2_errors,
    capsize=5,
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add the labels
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(cities)

# Add a legend
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Set labels for y-axes
ax1.set_ylabel(ylabels[0], color=colors[0])
ax2.set_ylabel(ylabels[1], color=colors[1])

# Set colors for y-axes
ax1.tick_params(axis="y", colors=colors[0])
ax2.tick_params(axis="y", colors=colors[1])

# Set the limits for y-axes to fit the data
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Set title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_118.pdf", bbox_inches="tight")
