
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data setup
import numpy as np

np.random.seed(42)

regions = ["Region A", "Region B", "Region C", "Region D"]
x = np.arange(len(regions))  # X-axis points

# Communication metrics for different regions
internet_penetration_rate = np.array([70.2, 65.4, 80.8, 88.1])  # Simulated values in percentage
mobile_phone_usage = np.array([80.6, 90.1, 85.2, 78.5])  # Simulated values in percentage

# Errors for both metrics
internet_penetration_errors = np.array([2.0, 2.5, 1.8, 2.2])
mobile_phone_usage_errors = np.array([1.5, 1.8, 2.0, 1.9])

labels = ["Internet Penetration Rate (%)", "Mobile Phone Usage (%)"]
ylabels = ["Internet Penetration Rate (%)", "Mobile Phone Usage (%)"]

title = "Communication Technology Usage Across Regions"
ylims = [[60, 100], [70, 95]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting setup
fig, ax1 = plt.subplots(figsize=(8, 5))

# Bar width and hatch patterns
width = 0.35
hatch_patterns = ["//", "o"]

# Colors for the bars
colors = ["#228B22", "#1E90FF"]  # Forest green and dodger blue

# Plot data on the left y-axis (internet penetration)
ax1.bar(
    x,
    internet_penetration_rate,
    width,
    color=colors[0],
    hatch=hatch_patterns[0],
    label=labels[0],
    yerr=internet_penetration_errors,
    capsize=5,
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis (mobile phone usage)
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    mobile_phone_usage,
    width,
    color=colors[1],
    hatch=hatch_patterns[1],
    label=labels[1],
    yerr=mobile_phone_usage_errors,
    capsize=5,
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add the labels
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(regions)

# Add a legend
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Set labels for y-axes
ax1.set_ylabel(ylabels[0], color=colors[0])
ax2.set_ylabel(ylabels[1], color=colors[1])

# Set colors for y-axes
ax1.tick_params(axis="y", colors=colors[0])
ax2.tick_params(axis="y", colors=colors[1])

# Set the limits for y-axes to fit the data
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Set title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_120.pdf", bbox_inches="tight")
