
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
events = [
    "Fall of the Berlin Wall",
    "Moon Landing",
    "World War II Ends",
    "Discovery of Penicillin",
    "Declaration of Independence",
    "Renaissance Begins",
    "Industrial Revolution Starts",
    "French Revolution",
    "Signing of Magna Carta",
    "Printing Press Invented",
]
log_impact_scores = [
    -0.30,
    -0.35,
    -0.25,
    -0.20,
    -0.45,
    -0.50,
    -0.40,
    -0.55,
    -0.60,
    -0.70,
]
errors = [0.03, 0.04, 0.02, 0.03, 0.04, 0.05, 0.03, 0.04, 0.05, 0.06]
ylabel = "Log Impact Score ↑"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#3b5998",  # Facebook blue
    "#1DA1F2",  # Twitter blue
    "#FF0000",  # YouTube red
    "#C13584",  # Instagram gradient
    "#69C9D0",  # TikTok turquoise
    "#6D6E70",  # Newspapers gray
    "#FF6600",  # Magazines orange
    "#00ADEF",  # TV blue
    "#E52D27",  # Radio red
    "#FC4C02",  # Blogs orange
]

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bars = ax.bar(
    events,
    log_impact_scores,
    yerr=errors,
    color=colors,
    capsize=5,
    error_kw={
        "ecolor": "darkgray",
    },
)

# Annotate bars with log impact scores
for bar, log_score, error, event in zip(bars, log_impact_scores, errors, events):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.1,
        f"{log_score:.2f}",
        ha="center",
        va="bottom",
    )
    # Add event name on the bar
    ax.text(
        bar.get_x() + bar.get_width() / 2, 0, event, ha="center", va="top", rotation=90
    )

# Legend
# ax.legend(legendtitle, loc="lower left")
ax.set_xticks([])
plt.tick_params(axis="x", which="both", length=0)
# Labels and grid
ax.set_ylabel(ylabel)
ax.set_ylim(-1.00, 0.00)

ax.yaxis.grid(True)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to match the original image's dimensions
plt.tight_layout()
plt.savefig("errorbar_31.pdf", bbox_inches="tight")
