
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
art_movements = [
    "Renaissance",
    "Baroque",
    "Rococo",
    "Neoclassicism",
    "Romanticism",
    "Impressionism",
    "Expressionism",
    "Cubism",
    "Surrealism",
    "Abstract",
]
popularity_scores = [
    7.5,
    6.8,
    6.2,
    7.0,
    5.9,
    6.7,
    5.5,
    6.1,
    5.8,
    6.4,
]
errors = [0.3, 0.4, 0.35, 0.3, 0.4, 0.35, 0.3, 0.4, 0.35, 0.3]  
legendtitle = ["Classical Movements", "Modern Movements"]
ylabel = "Popularity Score (1-10) ↑"
xlabel = ""

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8cb369"] * 5 + ["#f4a261"] * 5
# Plot
fig, ax = plt.subplots(figsize=(8, 5))
bars = ax.bar(
    art_movements,
    popularity_scores,
    yerr=errors,
    color=colors,
    capsize=10,
    error_kw={
        "ecolor": "gray",
    },
)

# Annotate bars with popularity score values
for bar, score_value, error, movement in zip(bars, popularity_scores, errors, art_movements):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.2,
        f"{score_value:.1f}",
        ha="center",
        va="bottom",
        fontsize=10
    )
    # Add movement name on the bar
    ax.text(
        bar.get_x() + bar.get_width() / 2, 0, movement, ha="center", va="top", rotation=90, fontsize=10
    )

# Create patches for the legend
patch1 = mpatches.Patch(color="#8cb369", label=legendtitle[0])
patch2 = mpatches.Patch(color="#f4a261", label=legendtitle[1])

# Add legend
ax.legend(handles=[patch1, patch2], loc="upper right", frameon=False)

# Labels and grid
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_ylim(0, 8)

ax.yaxis.grid(True)
ax.set_axisbelow(True)

# Hide x-tick labels
ax.set_xticks([])
plt.tick_params(axis="x", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to match the original image's dimensions
plt.tight_layout()
plt.savefig("errorbar_33.pdf", bbox_inches="tight")
