

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
schools = ["School A", "School B", "School C", "School D"]
subjects = [
    "Mathematics",
    "Science",
    "Literature",
    "History",
    "Art",
    "Physical Education",
]
performance_means = np.array(
    [
        [85, 75, 70, 90, 80, 95],  # School A
        [80, 70, 65, 85, 75, 90],  # School B
        [90, 85, 80, 95, 88, 98],  # School C
        [88, 78, 75, 92, 82, 96],  # School D
    ]
)
performance_std = np.array(
    [
        [3, 5, 4, 5, 6, 5],  # School A
        [4, 5, 6, 4, 5, 5],  # School B
        [3, 4, 5, 5, 4, 3],  # School C
        [4, 5, 5, 6, 5, 4],  # School D
    ]
)
legendtitle = "Subject"
xlabel = "School"
ylabel = "Performance (%)"
ylim = [50, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(12, 7))

# New artistic colors inspired by famous art movements
colors = [
    "#e69f00",  # Mathematics (Orange)
    "#56b4e9",  # Science (Sky Blue)
    "#009e73",  # Literature (Green)
    "#f0e442",  # History (Yellow)
    "#0072b2",  # Art (Blue)
    "#d55e00",  # Physical Education (Red)
]

# Bar width
bar_width = 0.15
bar_width_primary = 0.75

# Set position of bar on X axis
r = np.arange(len(schools))

# Draw bars for 'Mathematics' subject
i = subjects.index("Mathematics")
ax.bar(
    r + (i + 3) * bar_width,
    performance_means[:, i],
    yerr=performance_std[:, i],
    width=bar_width_primary,
    label=subjects[i],
    capsize=5,
    color=colors[i],
    hatch="///",
    edgecolor="black",
)

# Draw bars for other subjects
for i in range(len(subjects)):
    if subjects[i] == "Mathematics":
        continue
    ax.bar(
        r + i * bar_width,
        performance_means[:, i],
        yerr=performance_std[:, i],
        width=bar_width,
        label=subjects[i],
        capsize=5,
        color=colors[i],
        edgecolor="black",
    )

# Add xticks on the middle of the group bars
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(subjects) - 1) / 2)
ax.set_xticklabels(schools)

# Create legend & Show graphic
handles, labels = ax.get_legend_handles_labels()
order = [0, 1, 2, 4, 3, 5]  # Reordering the legend
ax.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper center",
    bbox_to_anchor=(0.5, 1.15),
    ncol=6,
    title=legendtitle,
)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis limit to accommodate error bars

# Improve aesthetics
ax.grid(True, which='both', linestyle='--', linewidth=0.5)
ax.set_facecolor('#f7f7f7')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_35.pdf", bbox_inches="tight")

