

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
curators = ["Modern Art Curators", "Classical Art Curators", "Digital Art Curators", "Sculpture Art Curators"]
art_categories = [
    "Paintings",
    "Sculptures",
    "Installations",
    "Photography",
    "Digital Art",
    "Performances",
]
satisfaction_means = np.array(
    [
        [85, 78, 74, 88, 92, 80],  # Modern Art Curators
        [80, 85, 77, 82, 86, 75],  # Classical Art Curators
        [90, 82, 85, 80, 95, 88],  # Digital Art Curators
        [78, 88, 82, 85, 83, 87],  # Sculpture Art Curators
    ]
)
satisfaction_std = np.array(
    [
        [4, 3, 5, 4, 3, 4],  # Modern Art Curators
        [3, 4, 4, 3, 4, 3],  # Classical Art Curators
        [3, 5, 4, 3, 2, 4],  # Digital Art Curators
        [5, 4, 3, 3, 4, 5],  # Sculpture Art Curators
    ]
)
legendtitle = "Art Categories"
xlabel = "Curator Groups"
ylabel = "Visitor Satisfaction (%)"
ylim = [0, 100]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(12, 8))

# colors (Health-themed colors)
colors = [
    "#add8e6",  # Light blue
    "#90ee90",  # Light green
    "#ffcccb",  # Light red
    "#ffd700",  # Gold
    "#dda0dd",  # Plum
    "#fa8072",  # Salmon
]

# Bar width
bar_width = 0.15
bar_width_expert = 0.75

# Set position of bar on X axis
r = np.arange(len(curators))

# Draw bars for 'Paintings' category
i = art_categories.index("Paintings")
ax.bar(
    r + (i + 3) * bar_width,
    satisfaction_means[:, i],
    yerr=satisfaction_std[:, i],
    width=bar_width_expert,
    label=art_categories[i],
    capsize=5,
    color=colors[i],
    hatch="//",
    edgecolor="black",
)

# Draw bars for other categories
for i in range(len(art_categories)):
    if art_categories[i] == "Paintings":
        continue
    ax.bar(
        r + i * bar_width,
        satisfaction_means[:, i],
        yerr=satisfaction_std[:, i],
        width=bar_width,
        label=art_categories[i],
        capsize=5,
        color=colors[i],
        edgecolor="black",
    )

# Add xticks on the middle of the group bars
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(art_categories) - 1) / 2)
ax.set_xticklabels(curators)

# Create legend & Show graphic
handles, labels = ax.get_legend_handles_labels()
order = [0, 1, 2, 4, 3, 5]  # Reordering the legend
ax.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper center",
    bbox_to_anchor=(0.5, 1.15),
    ncol=3,
    title=legendtitle,
)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis limit to accommodate error bars

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_36.pdf", bbox_inches="tight")

