
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data (Tourism Data)
countries = [
    "Country A",
    "Country B",
    "Country C",
    "Country D",
    "Country E",
    "Country F",
    "Country G",
    "Country H",
    "Country I",
    "Country J",
    "Country K",
    "Country L",
    "Country M",
    "Country N",
    "Country O",
    "Country P",
    "Country Q",
    "Country R",
]
tourists_values = np.random.rand(18) * 10_000  # Number of tourists in thousands
avg_spending_values = np.random.rand(18) * 5000  # Average spending per tourist in dollars
error = np.random.rand(18) * 500

# Labels and Plot Types
label_Tourists = "Number of Tourists (in thousands)"
label_Spending = "Average Spending (in $)"

# Axes Limits and Labels
xlabel_value = "Tourism Metrics"
ylabel_value = "Countries"
title = "Tourism Performance by Country"
ylim_values = [-0.4, 17.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(12, 10))

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(countries))
color_tourists = "#2d7f5e" # color for tourists bar
color_spending = "#de425b" # color for spending bar

plt.barh(
    index - 0.2,
    tourists_values,
    bar_width,
    color=color_tourists,
    hatch="..",
    xerr=error,
    label=label_Tourists,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)
plt.barh(
    index + 0.2,
    avg_spending_values,
    bar_width,
    color=color_spending,
    hatch="xx",
    xerr=error,
    label=label_Spending,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, countries, rotation=0)
plt.gca().set_ylim(ylim_values)

# Add legend
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_39.pdf", bbox_inches="tight")
