

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New Data for law domain
roles = ["Lawyer", "Judge", "Plaintiff", "Defendant", "Juror"]
duration_means = [120.5, 95.3, 80.4, 100.0, 110.6]
duration_errors = [10, 15, 5, 12, 7]
words_means = [1050.2, 750.4, 650.1, 900.8, 600.3]
words_errors = [50, 100, 30, 80, 40]

# Labels and Titles
ylabel1 = "Case Duration (hrs)"
xlabel1 = "(a) Case duration of roles"
ylabel2 = "Word Count"
xlabel2 = "(b) Word count of arguments"
suptitle = "Legal Role Analysis"
title1 = "Duration per Role"
title2 = "Word Count per Role"
legend_labels = ["Duration", "Word Count"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))
colors = ["#4daf4a", "#377eb8", "#ff7f00", "#984ea3", "#e41a1c"]

# Case duration of roles
ax1.bar(roles, duration_means, yerr=duration_errors, color=colors, capsize=5, alpha=0.7, edgecolor='black')
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
ax1.set_title(title1)
for i, v in enumerate(duration_means):
    ax1.text(i, v + duration_errors[i] + 2, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax1.set_axisbelow(True)

# Word count of arguments
ax2.bar(roles, words_means, yerr=words_errors, color=colors, capsize=5, alpha=0.7, edgecolor='black')
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
ax2.set_title(title2)
for i, v in enumerate(words_means):
    ax2.text(i, v + words_errors[i] + 20, str(v), ha="center", va="bottom")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True, linestyle='--', linewidth=0.7)
ax2.set_axisbelow(True)

# Add super title
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorbar_40.pdf", bbox_inches="tight")
