
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
issues = ["Healthcare", "Education", "Environment", "Economy", "Foreign Policy", "Immigration"]
samples = ["(1200 surveys)", "(1000 surveys)", "(1100 surveys)", "(1300 surveys)", "(900 surveys)", "(950 surveys)"]
x = range(len(issues))
y = [55.3, 60.4, 58.7, 62.5, 50.2, 53.6]
errors = [3.2, 2.5, 2.9, 2.1, 3.0, 2.8]
ylabel = "Public Support (%)"
xlabel = "Political Issues"
ylim = [45, 65]
yticks = [45, 50, 55, 60, 65]
title = "Public Opinion on Political Issues"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(figsize=(10, 7))
bars = plt.bar(x, y, yerr=errors, color="#4682B4", edgecolor="#2F4F4F", capsize=5)

# Adding data labels on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval + 0.5,
        round(yval, 2),
        ha="center",
        va="bottom",
        color="#2F4F4F"
    )

# Setting the x-axis labels with both issues and sample sizes
plt.xticks(x, [f"{issue}\n{sample}" for issue, sample in zip(issues, samples)], fontweight="bold")

# Setting the y-axis label and title
plt.ylabel(ylabel, fontsize=12, fontweight="bold")
plt.xlabel(xlabel, fontsize=12, fontweight="bold")
plt.title(title, fontsize=14, fontweight="bold")

# Adjusting y-axis range
plt.ylim(ylim)
plt.yticks(yticks, fontsize=11)
# Adding grid to the background
plt.grid(axis="y", alpha=0.7, which="both", linestyle="--", linewidth=0.7, color="gray")

# Making the axis lines more visible
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_color("#2F4F4F")
plt.gca().spines["left"].set_color("#2F4F4F")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_44.pdf", bbox_inches="tight")
