
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the left plot (Average Painting Prices per Year)
left_categories = [
    "Impressionism",
    "Cubism",
    "Surrealism",
    "Abstract",
    "Realism",
    "Baroque",
    "Rococo",
    "Modernism",
    "Expressionism",
    "Minimalism",
]
left_means = [50000, 60000, 45000, 70000, 30000, 80000, 55000, 90000, 35000, 40000]
left_errors = [5000, 7000, 4000, 8000, 3000, 9000, 5000, 10000, 3500, 4000]

# Data for the right plot (Exhibitions Held per Year)
right_categories = [
    "Impressionism",
    "Cubism",
    "Surrealism",
    "Abstract",
    "Realism",
    "Baroque",
    "Rococo",
    "Modernism",
    "Expressionism",
    "Minimalism",
]
right_means = [15, 18, 12, 20, 10, 25, 15, 30, 12, 14]
right_errors = [2, 3, 2, 4, 1, 5, 2, 5, 2, 3]

# Text labels and titles
title1 = "Average Painting Prices per Year (in USD)"
ylim1 = [0, 100000]
yticks1 = np.arange(0, 110000, 10000)
title2 = "Exhibitions Held per Year"
ylim2 = [0, 35]
suptitle = "Art and Design Data"
xlabel = "Art Styles"
ylabel1 = "Average Price (USD)"
ylabel2 = "Number of Exhibitions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Color palette
colors = ["#6b8e23", "#9acd32", "#556b2f", "#8fbc8f", "#228b22", "#32cd32", "#66cdaa", "#2e8b57", "#3cb371", "#adff2f"]

# Left plot
ax1.bar(
    left_categories,
    left_means,
    yerr=left_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1, capsize=5, capthick=2),
)
ax1.set_title(title1)
ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)
ax1.set_xticklabels(left_categories, rotation=90, ha="center")
ax1.tick_params(axis="both", length=0)  # Hide tick marks
ax1.grid(True)
ax1.set_axisbelow(True)
ax1.set_ylabel(ylabel1)
for spine in ax1.spines.values():
    spine.set_color("gray")

# Right plot
ax2.bar(
    right_categories,
    right_means,
    yerr=right_errors,
    color=colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1, capsize=5, capthick=2),
)
ax2.set_title(title2)
ax2.set_ylim(ylim2)
ax2.set_xticklabels(right_categories, rotation=90, ha="center")
ax2.tick_params(axis="both", length=0)  # Hide tick marks
ax2.grid(True)
ax2.set_axisbelow(True)
ax2.set_ylabel(ylabel2)

# Set the title for the entire figure
fig.suptitle(suptitle)

for spine in ax2.spines.values():
    spine.set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_47.pdf", bbox_inches="tight")
