
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = [
    "Ethics",
    "Metaphysics",
    "Epistemology",
    "Logic",
    "Aesthetics",
]
values = [0.70, 0.55, 0.65, 0.80, 0.60]
errors = [0.03, 0.04, 0.05, 0.02, 0.04]
xlabel = "Philosophical Metrics"
title = "Philosophical Study Performance Metrics"
label = "Average Score (0.66)"
xvline = 0.66

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(figsize=(10, 6))
colors = ["#FF5733", "#33FF57", "#3357FF", "#FF33A1", "#33FFF5"]  # Custom color scheme
plt.barh(categories, values, xerr=errors, color=colors, capsize=5)
plt.xlabel(xlabel)
plt.title(title, pad=20)
plt.gca().tick_params(axis="both", length=0)  # Hide tick marks

# Adding the vertical line
plt.axvline(x=xvline, color="red", linestyle="--", linewidth=2, label=label)
plt.gca().grid("both", color="gray", linestyle="--", linewidth=0.7, alpha=0.7)

# Adding the legend
plt.legend(loc="best")

# Customize spines for better visibility
for spine in plt.gca().spines.values():
    spine.set_color("gray")
    spine.set_linewidth(1.2)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_49.pdf", bbox_inches="tight")
