
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = [
    "Christianity",
    "Islam",
    "Hinduism",
    "Buddhism",
    "Judaism",
]
values = [31.2, 24.1, 15.0, 6.9, 0.2]
errors = [2.5, 1.8, 1.2, 0.5, 0.1]
xlabel = "Percentage of World Population"
title = "World Religious Demographics"
label = "Global Average (16%)"
xvline = 16

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(figsize=(10, 6))
colors = ["#76b041", "#4e9e9e", "#f4da40", "#f47d42", "#4286f4"]
plt.barh(categories, values, xerr=errors, color=colors, capsize=5)
plt.xlabel(xlabel)
plt.title(title)
plt.gca().tick_params(axis="both", length=0)  # Hide tick marks

# Adding the vertical line
plt.axvline(x=xvline, color="red", linestyle="--", label=label)
plt.gca().grid("both", color="gray", alpha=0.7)

# Adding the legend
plt.legend()

for spine in plt.gca().spines.values():
    spine.set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_50.pdf", bbox_inches="tight")
