
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data (fictional data for illustration)
import numpy as np

np.random.seed(0)

age_groups = [
    "0-14",
    "15-24",
    "25-34",
    "35-44",
    "45-54",
    "55-64",
    "65-74",
    "75-84",
    "85+",
]
actual_health_metrics = [5000, 7000, 8000, 7500, 6000, 5000, 4000, 3000, 2000]
forecasted_health_metrics = [4800, 6800, 7800, 7300, 5800, 4800, 3800, 2800, 1800]
error = [500, 700, 800, 750, 600, 500, 400, 300, 200]
labels = ["Actual Health Metrics", "Forecasted Health Metrics"]
ylabel = "Average Steps per Day"
ylim = [0, 10000]
yticks = np.arange(0, 10001, 1000)

# Text labels for the chart
xlabel = "Age Groups"
title = "Actual vs Forecasted Health Metrics by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 6))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(actual_health_metrics))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    actual_health_metrics,
    color="#8CC084",
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    forecasted_health_metrics,
    color="#58A6FF",
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(actual_health_metrics))], age_groups)

# Create legend & Show graphic
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.legend(frameon=False, loc="upper left")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#F5F5F5")
plt.grid(color="white", linestyle="-", linewidth=0.5, axis="both")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

# Remove chart spines
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_53.pdf", bbox_inches="tight")
