

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Categories and values (religious community data for a specific year)
categories = [
    "Number of Active Members",
    "Average Weekly Attendance",
    "Number of Community Services",
    "Religious Education Programs",
    "Annual Donations (in $1000s)",
    "Number of Clergy",
    "Number of New Members",
][::-1]
values = [500, 300, 20, 15, 250, 10, 50][::-1]
error = [50, 30, 5, 2, 25, 1, 10]

# Labels and title
xlabel = "Measurements"
ylabel = "Community Parameters"
title = "Religious Community Data for 2023"
xlim = [0, 600]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
fig, ax = plt.subplots(figsize=(10, 8))  # Adjust figure size
bars = ax.barh(
    categories,
    values,
    color=["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"],
    edgecolor="white",
    height=0.5,
    xerr=error,
    capsize=5,
)

# Set labels and title (if any)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Invert y-axis to match the image
ax.invert_yaxis()

# Set x-axis range to match the reference image
ax.set_xlim(xlim)

# Remove grid lines and make spines less visible
ax.xaxis.grid(False)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Set background color to white
ax.set_facecolor("white")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_55.pdf", bbox_inches="tight")

