

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Categories and values
categories = [
    "Student Satisfaction",
    "Graduation Rate",
    "Faculty Performance",
    "Infrastructure Quality",
    "Research Output",
    "Curriculum Relevance",
    "Extracurricular Activities",
][::-1]
values = [7.8, 8.4, 6.9, 7.3, 8.1, 7.6, 7.0][::-1]
error = [0.4, 0.3, 0.5, 0.2, 0.4, 0.3, 0.2]
xlabel = "Performance Score"
ylabel = "Educational Metrics"
title = "Educational Institution Performance Analysis"
xlim = [6, 9]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
fig, ax = plt.subplots(figsize=(10, 8))  # Adjust figure size
bars = ax.barh(
    categories,
    values,
    color="#4F81BD",
    edgecolor="white",
    height=0.5,
    xerr=error,
    capsize=4,
    ecolor="#B0C4DE",
)

# Set labels and title (if any)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=16, fontweight='bold')

# Invert y-axis to match the image
ax.invert_yaxis()

# Set x-axis range
ax.set_xlim(xlim)

# Remove grid lines
ax.xaxis.grid(False)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Set background color to white
ax.set_facecolor("white")

# Adding grid lines for better readability
ax.xaxis.grid(True, linestyle='--', which='major', color='grey', alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_57.pdf", bbox_inches="tight")

