

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = [2018, 2019, 2020, 2021]
baseline = [5, 5.2, 5.5, 5.8]
method_a = [4.8, 5.1, 5.3, 5.6]
method_b = [4.9, 5.0, 5.4, 5.7]
errors = [0.2, 0.3, 0.3, 0.2]

# Labels and Plot Types
label1 = "Estimate A"
label2 = "Estimate B"
label3 = "Actual Population Growth"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Population Growth (in millions)"
title = "Population Growth Estimates Over Years"
xticklabels = ["2018", "2019", "2020", "2021"]
ylim_values = [4, 6.5]
yticks_values = np.arange(4, 7, 0.5)
legend_title = "Estimates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for the given dimensions
bar_width = 0.35
opacity = 0.8

color_method_a = "#76c7c0"
color_method_b = "#ffcc5c"
color_baseline = "#d9534f"

bar1 = ax.bar(
    np.array(years) - bar_width / 2,
    method_a,
    bar_width,
    alpha=opacity,
    color=color_method_a,
    label=label1,
    yerr=errors,
    capsize=5,
)

bar2 = ax.bar(
    np.array(years) + bar_width / 2,
    method_b,
    bar_width,
    alpha=opacity,
    color=color_method_b,
    label=label2,
    yerr=errors,
    capsize=5,
)

ax.plot(
    years,
    baseline,
    linestyle="--",
    color=color_baseline,
    linewidth=2,
    marker='o',
    markersize=8,
    label=label3,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(years)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper right", title=legend_title)

# Additional aesthetic adjustments
ax.grid(True, linestyle='--', alpha=0.6)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_58.pdf", bbox_inches="tight")

