

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
quarters = [1, 2, 3, 4]
baseline = [25] * len(quarters)  # Average baseline revenue in billions
apple_revenue = [30, 32, 35, 34]
microsoft_revenue = [28, 29, 31, 30]
google_revenue = [26, 27, 29, 28]
amazon_revenue = [33, 35, 37, 36]
errors = [1, 1.5, 2, 1]

# Labels and Plot Types
label1 = "Apple"
label2 = "Microsoft"
label3 = "Google"
label4 = "Amazon"
label_baseline = "Baseline Revenue"

# Axes Limits and Labels
xlabel_value = "Quarter of the Year"
ylabel_value = "Average Quarterly Revenue (in billions)"
title = "Quarterly Revenue by Tech Company"
xticklabels = ["Q1", "Q2", "Q3", "Q4"]
ylim_values = [20, 40]
yticks_values = np.arange(20, 41, 5)
legend_title = "Technology Company"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for the given dimensions
bar_width = 0.2
opacity = 0.8

bar1 = ax.bar(
    np.array(quarters) - 1.5 * bar_width,
    apple_revenue,
    bar_width,
    alpha=opacity,
    color="#ff9999",
    label=label1,
    yerr=errors,
    capsize=3,
)

bar2 = ax.bar(
    np.array(quarters) - 0.5 * bar_width,
    microsoft_revenue,
    bar_width,
    alpha=opacity,
    color="#66b3ff",
    label=label2,
    yerr=errors,
    capsize=3,
)

bar3 = ax.bar(
    np.array(quarters) + 0.5 * bar_width,
    google_revenue,
    bar_width,
    alpha=opacity,
    color="#99ff99",
    label=label3,
    yerr=errors,
    capsize=3,
)

bar4 = ax.bar(
    np.array(quarters) + 1.5 * bar_width,
    amazon_revenue,
    bar_width,
    alpha=opacity,
    color="#ffcc99",
    label=label4,
    yerr=errors,
    capsize=3,
)

ax.plot(
    quarters,
    baseline,
    linestyle="--",
    color="black",
    linewidth=2,
    label=label_baseline,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(quarters)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper left", title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_59.pdf", bbox_inches="tight")

