
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data (Stock price changes in percentage)
means = [np.random.uniform(-2, 5, 3) for _ in range(4)]
errors = [np.random.uniform(0.1, 1.0, 3) for _ in range(4)]

# Labels
companies = ["Company X", "Company Y", "Company Z", "Company W"]
months = np.arange(3)  # Represents the three months

labels_per_subplot = [
    ["Company Y", "Company Z", "Company W"],
    ["Company X", "Company Z", "Company W"],
    ["Company X", "Company Y", "Company W"],
    ["Company X", "Company Y", "Company Z"],
]
supertitle = "Average Stock Price Changes (Last 3 Months)"
xlabel = "Month"
ylabel = "Stock Price Change (%)"
ylim = [-2, 5]
yticks = np.arange(-2, 6, 1)
xticklabels = ['Month 1', 'Month 2', 'Month 3']
legends = ["Month 1", "Month 2", "Month 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(10, 6))

# Define colors for each bar set
colors = [
    ["#4c72b0", "#55a868", "#c44e52"],
    ["#8172b3", "#ccb974", "#64b5cd"],
    ["#8c564b", "#e377c2", "#7f7f7f"],
    ["#bcbd22", "#17becf", "#e7969c"],
]

# Loop through each subplot to set properties
for i, ax in enumerate(axs.flat):
    ax.bar(months, means[i], yerr=errors[i], color=colors[i], edgecolor="black", capsize=5)
    ax.set_title(f"{companies[i]}")
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_xticks(months)
    ax.set_xticklabels(xticklabels)
    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.set_ylim(ylim)
    ax.set_yticks(yticks)
    ax.set_facecolor("#f5f5f5")
    ax.yaxis.grid(color="white", linestyle="-", linewidth=1)
    ax.set_axisbelow(True)
    ax.tick_params(axis="both", length=0)

# Add a supertitle for the entire figure
fig.suptitle(supertitle, fontsize=16)

# Create a custom legend
fig.legend(
    legends,
    loc="lower center",
    ncol=3,
    bbox_to_anchor=(0.5, -0.1),
    facecolor="#f5f5f5"
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.95])
# Save the figure
plt.savefig("errorbar_66.pdf", bbox_inches="tight")
