# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Assessment 1\n(Teens)",
    "Assessment 2\n(Adults)",
    "Assessment 3\n(Seniors)",
    "Assessment 4\n(All)",
][::-1]
subcategories = [
    "Listening",
    "Speaking",
    "Non-verbal Communication",
    "Written Communication",
][::-1]
values = [
    [0.70, 0.72, 0.74, 0.76],
    [0.75, 0.77, 0.79, 0.81],
    [0.80, 0.78, 0.76, 0.74],
    [0.72, 0.74, 0.76, 0.78],
]
errors = [
    [0.02, 0.01, 0.02, 0.01],
    [0.01, 0.02, 0.01, 0.02],
    [0.02, 0.03, 0.01, 0.02],
    [0.01, 0.02, 0.02, 0.01],
]
percentages = [
    "+4.3%",  # 0.70 -> 0.72 -> 0.74 -> 0.76
    "+4.8%",  # 0.75 -> 0.77 -> 0.79 -> 0.81
    "+4.0%",  # 0.80 -> 0.78 -> 0.76 -> 0.74
    "+4.5%",  # 0.72 -> 0.74 -> 0.76 -> 0.78
    "+5.2%",
    "+6.1%",
    "+5.3%",
    "+4.9%",  # 假设补充
    "+4.0%",
    "+5.0%",
    "+5.7%",
    "+4.1%",  # 假设补充
    "+5.9%",
    "+6.0%",
    "+5.2%",
    "+4.8%",  # 假设补充
][::-1]
xlim = [0.65, 0.85]

# Labels
xlabel = "Competency Score"
ylabel = categories
suptitle = "Competency Scores of Communication Skills Assessments"
title = "Communication Skills Assessments across Different Demographics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axes = plt.subplots(4, 1, figsize=(10, 8), sharex=True)

# Define new color scheme
colors = ["#a1c4fd", "#c2e9fb", "#fbc2eb", "#a1c4fd"]

for i, ax in enumerate(axes):
    ax.barh(
        subcategories,
        values[i][::-1],
        xerr=errors[i],
        color=colors[i],
        edgecolor="black",
        capsize=5,
    )
    ax.set_yticklabels(subcategories)
    ax.set_xlim(xlim)
    ax.set_ylabel(categories[i], fontsize=12)
    for j, v in enumerate(values[i][::-1]):
        ax.text(
            v + errors[i][j] + 0.01,
            j,
            percentages[i * 4 + j],
            color="black",
            va="center",
            fontsize=10,
            fontweight="bold",
        )

# Global plot settings
fig.suptitle(suptitle, fontsize=16, fontweight="bold")
axes[-1].set_xlabel(xlabel, fontsize=12)
plt.tight_layout(rect=[0, 0, 1, 0.96])

plt.savefig("errorbar_68.pdf", bbox_inches="tight")
