
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
temperature_change = [1.5, 2.1, -0.4, 3.2, 2.8, -1.0, -0.5, 1.7, 2.5, -0.3, 1.2, 1.8]
temperature_errors = [0.5, 0.4, 0.6, 0.3, 0.5, 0.4, 0.3, 0.6, 0.5, 0.4, 0.3, 0.5]

# Axes Limits and Labels
ylabel_value = "Avg Temperature Change\n(Compared to historical data)"
ylim_values = [-2, 4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#4c72b0",
    "#55a868",
    "#c44e52",
    "#8172b3",
    "#ccb974",
    "#64b5cd",
    "#8d8e8e",
    "#e17c7c",
    "#f08080",
    "#b0e57c",
    "#b0c4de",
    "#ffa07a",
]

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar chart
bars = ax.bar(
    months, temperature_change, yerr=temperature_errors, color=colors, capsize=5, edgecolor="none", error_kw=dict(ecolor='black', lw=1)
)
ax.set_xticks([])
# Set labels
ax.set_ylabel(ylabel_value)

# Set x-axis limits and y-axis limits
ax.set_ylim(ylim_values)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)

# Remove grid lines
ax.yaxis.grid(False)
ax.xaxis.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of ylabel
plt.tight_layout()
plt.savefig("errorbar_72.pdf", bbox_inches="tight")
