

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
categories = ["Classification", "Regression", "Clustering"]
methods = ["Model X", "Model Y", "Model Z", "Model W"]
performance = np.array([[85, 80, 78, 84], [75, 80, 70, 72], [65, 60, 67, 68]])
errors = np.array([[3, 4, 5, 3], [5, 4, 6, 7], [6, 5, 4, 5]])
ylim = [50, 90]
ylabel = "Model Accuracy (%)"
xlabel = "Tasks"
legend_labels = methods

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size 720x216 pixels
fig, axes = plt.subplots(1, 3, figsize=(10, 3))
# Colors
colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728"]

# Bar width
bar_width = 1

# Plotting bars
for i, ax in enumerate(axes):
    for j, method in enumerate(methods):
        ax.bar(
            j + bar_width * i,
            performance[i, j],
            width=bar_width,
            color=colors[j],
            alpha=0.7,
            yerr=errors[i, j],
            capsize=5,
            label=method if i == 0 else "",
        )

# Setting x-axis labels, y-axis limits, and titles
for i, ax in enumerate(axes):
    ax.set_xticks([])
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel if i == 0 else "")
    ax.yaxis.grid(True, linestyle='--', linewidth=0.7)
    ax.set_axisbelow(True)

# Adding legend outside of the plot
fig.legend(legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=len(methods))

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_73.pdf", bbox_inches="tight")

