

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for energy domain
countries = ["United States", "Germany", "India", "Brazil", "Japan"]
renewable_percentage = [0.35, 0.52, 0.20, 0.45, 0.30]  # Percentage of renewable energy usage
percentage_errors = [0.04, 0.03, 0.05, 0.02, 0.03]

countries2 = ["United States", "Germany", "India", "Brazil", "Japan"]
renewable_projects = [1200, 900, 800, 850, 700]  # Number of renewable energy projects
projects_errors = [100, 80, 70, 60, 50]

titles = ["Percentage of Renewable Energy Usage", "Number of Renewable Energy Projects"]

xlabel = "Percentage"
xlabel2 = "Number of Projects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color scheme
colors = ["#7B8D42", "#A1C298", "#B6C9A5", "#D1E8E4", "#9DB4AB"]

fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))

# Plot for the first data set
ax1.barh(countries, renewable_percentage, xerr=percentage_errors, color=colors, capsize=5, edgecolor="black")
ax1.set_xlabel(xlabel)
ax1.set_title(titles[0])
ax1.grid(True, linestyle='--', alpha=0.5)

# Plot for the second data set
ax2.barh(countries2, renewable_projects, xerr=projects_errors, color=colors, capsize=5, edgecolor="black")
ax2.set_xlabel(xlabel2)
ax2.set_title(titles[1])
ax2.grid(True, linestyle='--', alpha=0.5)

# Tight layout for better spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorbar_79.pdf", bbox_inches="tight")

