
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data: Average Annual Rainfall in Different Regions
regions = ["Amazon Basin", "Sahara Desert", "Great Plains", "Himalayas", "Siberian Tundra"]
rainfall = [2200, 100, 600, 1500, 300]
rainfall_errors = [100, 10, 50, 100, 30]

# Data: Number of Rainy Days in Different Regions
regions2 = ["Amazon Basin", "Sahara Desert", "Great Plains", "Himalayas", "Siberian Tundra"]
rainy_days = [200, 20, 100, 150, 50]
rainy_days_errors = [10, 2, 8, 10, 4]

titles = ["Average Annual Rainfall in Different Regions (mm)", "Number of Rainy Days in Different Regions"]

# Text Labels
xlabel1 = "Rainfall (mm)"
xlabel2 = "Number of Rainy Days"
ylabel = "Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff7f0e", "#2ca02c", "#1f77b4", "#d62728", "#9467bd"]  # Vibrant colors
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8))

# First subplot
ax1.barh(regions, rainfall, xerr=rainfall_errors, color=colors, capsize=5, edgecolor='black')
ax1.set_title(titles[0])
ax1.set_xlabel(xlabel1)
ax1.set_ylabel(ylabel)

# Second subplot
ax2.barh(regions2, rainy_days, xerr=rainy_days_errors, color=colors, capsize=5, edgecolor='black')
ax2.set_title(titles[1])
ax2.set_xlabel(xlabel2)
ax2.set_ylabel(ylabel)

# Improve layout
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorbar_81.pdf", bbox_inches="tight")
