
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data representing crop yield performance for three different regions
categories = ["Midwest", "South", "West Coast"]
metrics = [
    "Wheat Yield",
    "Corn Yield",
    "Soybean Yield",
    "Rice Yield",
]
performance = np.array(
    [
        [95, 88, 85, 78],
        [92, 85, 82, 80],
        [90, 83, 80, 75],
    ]
)
errors = np.array(
    [
        [2, 4, 3, 5],
        [3, 5, 4, 4],
        [4, 3, 5, 6],
    ]
)
ylim = [70, 100]
ylabel = "Yield Performance Percentage"
xlabel_suffix = "Crop Yield Metrics"
legend_labels = metrics
figure_title = "Crop Yield Performance Metrics in Different Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size to match a 3x1 subplot layout
fig, axes = plt.subplots(3, 1, figsize=(10, 9), sharex=True)
# Colors, choosing a different palette to differentiate the plots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plotting bars
for i, ax in enumerate(axes):
    for j, metric in enumerate(metrics):
        ax.bar(
            j,
            performance[i, j],
            width=0.8,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=metric if i == 0 else "",
        )

    # Setting x-axis labels, y-axis limits, and titles
    ax.set_xticks(range(len(metrics)))
    ax.set_xticklabels(metrics, rotation=45)
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding a legend outside of the plot on top
fig.legend(legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=len(metrics))
plt.suptitle(figure_title, y=1.02)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to prevent overlap and ensure labels are visible
plt.tight_layout()
plt.savefig("errorbar_86.pdf", bbox_inches="tight")
