
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Weather data for different cities
cities = ["City A", "City B", "City C", "City D"]
x = np.arange(len(cities))  # Location of labels on the x-axis

# Simplified data arrays to two seasons per metric
temperature = np.array(
    [np.random.uniform(15, 30, 4), np.random.uniform(0, 15, 4)]
).T  # Summer and Winter temperatures (°C)
rainfall = np.array(
    [np.random.uniform(50, 150, 4), np.random.uniform(20, 80, 4)]
).T  # Summer and Winter rainfall (mm)
wind_speed = np.array(
    [np.random.uniform(5, 15, 4), np.random.uniform(3, 12, 4)]
).T  # Summer and Winter wind speed (km/h)
humidity = np.array(
    [np.random.uniform(40, 70, 4), np.random.uniform(20, 50, 4)]
).T  # Summer and Winter humidity (%)
# Errors for each season
temperature_errors = np.array([np.random.randint(1, 3, 4), np.random.randint(1, 3, 4)]).T
rainfall_errors = np.array([np.random.randint(5, 10, 4), np.random.randint(5, 10, 4)]).T
wind_speed_errors = np.array([np.random.randint(1, 2, 4), np.random.randint(1, 2, 4)]).T
humidity_errors = np.array([np.random.randint(2, 5, 4), np.random.randint(2, 5, 4)]).T

labels = ["Summer", "Winter"]
titles = [
    "Temperature (°C)",
    "Rainfall (mm)",
    "Wind Speed (km/h)",
    "Humidity (%)",
]
ylabels = ["Temperature (°C)", "Rainfall (mm)", "Wind Speed (km/h)", "Humidity (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(12, 8))  # Adjusted to 2 rows and 2 columns
axs = axs.flatten()

# Define colors for each set of bars to keep the design cohesive and attractive
colors = [
    ["#ffa07a", "#ff4500"],  # Summer and Winter for temperature
    ["#add8e6", "#0000ff"],  # Summer and Winter for rainfall
    ["#90ee90", "#008000"],  # Summer and Winter for wind speed
    ["#dda0dd", "#800080"],
]  # Summer and Winter for humidity

# Helper function to plot data
def plot_data(ax, j, data, errors, title, ylabel):
    for i in range(2):  # Adjusted to only two bars per city
        ax.bar(
            x + i * 0.2,
            data[:, i],
            yerr=errors[:, i],
            color=colors[j][i],
            label=labels[i],
            width=0.2,
            capsize=3,
        )
    ax.set_title(title)
    ax.set_xticks(x + 0.1)  # Adjust position to center the group
    ax.set_xticklabels(cities)
    ax.set_ylabel(ylabel)
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2)

# Plot each category of weather data
plot_data(axs[0], 0, temperature, temperature_errors, titles[0], ylabels[0])
plot_data(axs[1], 1, rainfall, rainfall_errors, titles[1], ylabels[1])
plot_data(axs[2], 2, wind_speed, wind_speed_errors, titles[2], ylabels[2])
plot_data(axs[3], 3, humidity, humidity_errors, titles[3], ylabels[3])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_88.pdf", bbox_inches="tight")
