
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Countries and values for CO2 emissions and renewable energy generation
countries = ["France", "Canada", "Japan", "Australia", "Russia"][::-1]
co2_emissions = [-3000, -4500, -4000, -5500, -4700][::-1]  # CO2 emissions in million tonnes
co2_emissions_error = [500, 600, 550, 700, 650][::-1]  # Error values for CO2 emissions

renewable_energy = [2500, 3000, 2800, 3500, 3200][::-1]  # Renewable energy in million MWh
renewable_energy_error = [400, 500, 450, 600, 550][::-1]  # Error values for renewable energy
xlabels = ["CO2 Emissions", "Renewable Energy"]
titles = ["CO2 Emissions by Country", "Renewable Energy by Country"]
xlims = [[-7000, 0], [0, 4000]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 8), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#ff9999"] * 5  # Color scheme for CO2 emissions
pos_colors = ["#66b3ff"] * 5  # Color scheme for renewable energy

# Plotting bars for negative values (CO2 Emissions)
bars = axes[0].barh(
    countries,
    co2_emissions,
    color=neg_colors,
    edgecolor="black",
    height=0.5,
    xerr=co2_emissions_error,
    capsize=5,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0])
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Renewable Energy)
bars2 = axes[1].barh(
    countries,
    renewable_energy,
    color=pos_colors,
    edgecolor="black",
    height=0.5,
    xerr=renewable_energy_error,
    capsize=5,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1])
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_91.pdf", bbox_inches="tight")
