

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for Average Communication Speeds in different areas
areas = ["Urban", "Suburban", "Rural"]
speed_internet = [70, 50, 20]  # Average Internet Speed (Mbps)
speed_mobile_data = [60, 45, 25]  # Average Mobile Data Speed (Mbps)
speed_landline = [50, 40, 15]  # Average Landline Speed (Mbps)
error = [5, 4, 3]  # Error margins for the speed measurements

# Bar positions
x = np.arange(len(areas))
width = 0.25  # width of the bars

labels = ["Internet", "Mobile Data", "Landline"]
ylabel = "Average Speed (Mbps)"
title = "Average Communication Speeds by Area"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width,
    speed_internet,
    width,
    label=labels[0],
    color="skyblue",
    yerr=error,
    capsize=5,
    hatch="//",
)
bars2 = ax.bar(
    x,
    speed_mobile_data,
    width,
    label=labels[1],
    color="lightgreen",
    yerr=error,
    capsize=5,
    hatch="\\",
)
bars3 = ax.bar(
    x + width,
    speed_landline,
    width,
    label=labels[2],
    color="lightcoral",
    yerr=error,
    capsize=5,
    hatch="--",
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(areas)
ax.axhline(0, color="gray", linewidth=0.8)
ax.legend()

# Adding grid for better readability
ax.yaxis.grid(True, linestyle='--', alpha=0.7)

# Adding data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            f"{height:.2f}",
            xy=(
                bar.get_x() + bar.get_width() / 2,
                (
                    height + error[bars.index(bar)]
                    if height > 0
                    else height - error[bars.index(bar)]
                ),
            ),
            xytext=(
                0,
                3 if height > 0 else -12,
            ),  # move text up or down based on bar direction
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("errorbar_95.pdf", bbox_inches="tight")

