
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for different environmental metrics
metrics = ["Air Quality", "Water Quality", "Soil Health"]
scores_2000 = [65, 70, 55]  # Scores in the year 2000
scores_2010 = [75, 65, 60]  # Scores in the year 2010
scores_2020 = [85, 75, 70]  # Scores in the year 2020
error = [4, 5, 3]  # Error margins for the scores

# Bar positions
x = np.arange(len(metrics))
width = 0.25  # width of the bars

xlabel = "Environmental Metrics"
ylabel = "Quality Score"
title = "Quality of Environmental Metrics Over Time"
labels = ["Year 2000", "Year 2010", "Year 2020"]
legend_labels = ["Metric", "Score", "Time Period"]
annotation_texts = ["year 2000", "year 2010", "year 2020"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width, 
    scores_2000, 
    width, 
    label=labels[0], 
    color="#FF7F50",  # Coral
    yerr=error, 
    capsize=5, 
    hatch="//"
)
bars2 = ax.bar(
    x, 
    scores_2010, 
    width, 
    label=labels[1], 
    color="#3CB371",  # Medium Sea Green
    yerr=error, 
    capsize=5, 
    hatch="\\"
)
bars3 = ax.bar(
    x + width, 
    scores_2020, 
    width, 
    label=labels[2], 
    color="#6495ED",  # Cornflower Blue
    yerr=error, 
    capsize=5, 
    hatch="--"
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(metrics)
ax.axhline(0, color="gray")
ax.legend()  # Adjust legend location as needed

# Adding data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            f"{height:.2f}",
            xy=(
                bar.get_x() + bar.get_width() / 2,
                (
                    height + error[bars.index(bar)]
                    if height > 0
                    else height - error[bars.index(bar)]
                ),
            ),
            xytext=(
                0,
                3 if height > 0 else -12,
            ),  # move text up or down based on bar direction
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("errorbar_96.pdf", bbox_inches="tight")
