

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
entities = ["Agriculture", "Industry", "Services", "Technology"]
protocols = [
    "GDP Growth",
    "Employment Rate",
    "Inflation Rate",
    "Investment Level",
    "Productivity",
    "Trade Balance",
]
# Simulated mean scores for different protocols (domain-specific values)
efficiency_means = np.array(
    [
        [3, 5, 2, 6, 4, 3],  # Agriculture
        [4, 7, 3, 8, 5, 4],  # Industry
        [6, 6, 2, 7, 6, 5],  # Services
        [7, 5, 1, 9, 8, 6],  # Technology
    ]
)

# Simulated standard deviations for scores (more diverse)
efficiency_std = np.array(
    [
        [0.5, 0.7, 0.6, 0.8, 0.5, 0.4],  # Agriculture
        [0.8, 0.6, 0.7, 0.5, 0.9, 0.6],  # Industry
        [0.6, 0.8, 0.5, 1.0, 0.7, 0.5],  # Services
        [0.7, 0.9, 0.8, 0.6, 0.6, 0.7],  # Technology
    ]
)
xlabel = "Economic Sector"
ylabel = "Performance Metrics (%)"
ylim = [0, 10]
legendtitle = "Economic Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Vibrant color palette
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1", "#955251"]

# Bar width and positions
bar_width = 0.12

# Positions of the bar groups
r = np.arange(len(entities))

# Drawing bars for different protocols
for i in range(len(protocols)):
    ax.bar(
        r + i * bar_width,
        efficiency_means[:, i],
        yerr=efficiency_std[:, i],
        width=bar_width,
        label=protocols[i],
        capsize=3,
        color=colors[i],
        edgecolor="black",
    )

# Set x-axis labels and axis properties
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(protocols) / 2))
ax.set_xticklabels(entities)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis to better fit extended range

# Customize the legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.4), title=legendtitle, ncol=3)

# Additional plot formatting
plt.tight_layout()
plt.grid(visible=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_99.pdf", bbox_inches="tight")

