
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for entertainment domain
categories = [
    "Streaming Services",
    "TV Shows",
    "Movies",
    "Music",
    "Gaming",
    "Social Media",
]
means = np.random.uniform(0.2, 0.8, len(categories))
std_devs = np.random.uniform(0.05, 0.15, len(categories))
dataset_mean = np.mean(means)

# Labels and Plot Types
label_Mean = "Mean Popularity"
label_Dataset_mean = "Overall Popularity Mean"

# Axes Limits and Labels
ylabel_value = "Popularity Fraction (Fraction of population)"
xlabel_value = "Entertainment Categories"
title_chart = "Popularity of Different Entertainment Activities"
ylim_values = [0.1, 0.9]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Error bar plot
ax.errorbar(
    categories,
    means,
    yerr=std_devs,
    fmt="o",
    color="#1f77b4",  # blue color
    ecolor="#ff7f0e",  # orange color for error bars
    capsize=5,
    label=label_Mean,
    marker='s',  # square marker
    markersize=8,
    linestyle='--',
    linewidth=1,
)

# Dataset mean line
ax.axhline(y=dataset_mean, color="#2ca02c", linestyle="--", linewidth=2, label=label_Dataset_mean)  # green dashed line

# Customizing the plot
ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_title(title_chart)
ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=12)
ax.legend()
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_22.pdf", bbox_inches="tight")

