
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(27)

# Data for plotting
teams = [
    "Team A",
    "Team B",
    "Team C",
    "Team D",
    "Team E",
    "Team F",
    "Team G",
    "Team H",
    "Team I",
    "Team J",
]
goals_per_game = [
    2.5,
    2.7,
    1.8,
    2.3,
    2.1,
    1.9,
    2.0,
    2.4,
    1.7,
    2.2,
]
errors = [
    [0.2, -0.3],
    [0.1, -0.2],
    [0.3, -0.2],
    [0.2, -0.1],
    [0.1, -0.2],
    [0.2, -0.3],
    [0.3, -0.1],
    [0.1, -0.2],
    [0.2, -0.1],
    [0.3, -0.2],
]
methods = [
    "Season 2015-2016",
    "Season 2016-2017",
    "Season 2017-2018",
    "Season 2018-2019",
    "Season 2019-2020",
    "Season 2020-2021",
    "Season 2021-2022",
    "Season 2022-2023",
    "Season 2023-2024",
    "Season 2024-2025",
]
xticks = np.arange(1.5, 3.1, 0.3)
xlim = [1.5, 3.0]
xvline = 2.3
xvspan = [2.1, 2.4]

# Text Label Parameters
xlabel = "Average Goals per Game"
title = "Average Goals per Game by Team Over Seasons"
supertitle = "Comparative Analysis of Football Teams"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (team, goals, error) in enumerate(zip(teams, goals_per_game, errors)):
    ax.errorbar(
        goals,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="blue",
        ecolor="green",
        capsize=3,
    )
    ax.text(
        goals,
        i - 0.15,
        r"$%.1f^{+%.1f} _{-%.1f}$" % (goals, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
    )

# Highlighted region with adjusted color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="cyan", alpha=0.3)

# Text for methods with adjusted font size
for i, method in enumerate(methods):
    ax.text(3.1, i, method, va="center", ha="left", fontsize=11)

# Set labels and title
ax.set_yticks(range(len(teams)))
ax.set_yticklabels(teams)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.invert_yaxis()
ax.axvline(x=xvline, linestyle="--", color="red")

# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.suptitle(supertitle, fontsize=14, fontweight='bold')
plt.title(title, fontsize=12)
plt.tight_layout()
plt.savefig("errorpoint_27.pdf", bbox_inches="tight")
