
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for literature domain
categories = [
    "Fiction",
    "Non-Fiction",
    "Science Fiction",
    "Fantasy",
    "Mystery",
    "Biography",
]

unique_author_mean = [12, 15, 9, 18, 11, 14]  # Generated mean values
unique_critic_mean = [5, 7, 4, 8, 6, 7]  # Generated mean values
unique_author_error = [1.5, 1.8, 1.2, 2, 1.3, 1.7]  # Generated error values
unique_critic_error = [1, 1.1, 0.9, 1.3, 1, 1.5]  # Generated error values

# Text labels
labels = ["Unique author count mean", "Unique critic count mean"]
ylabel = "Number of authors and critics"
axlabel = "Average unique critic count mean"
title = "Literature Domain: Author and Critic Statistics"
legendlabels = ["Mean author count", "Mean critic count", "Overall critic mean"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars with custom styles
ax.errorbar(
    categories,
    unique_author_mean,
    yerr=unique_author_error,
    fmt="o",
    color="#1f77b4",
    label=labels[0],
    ecolor='#1f77b4',
    elinewidth=2,
    capsize=5,
    marker='s',
    markersize=7
)
ax.errorbar(
    categories,
    unique_critic_mean,
    yerr=unique_critic_error,
    fmt="o",
    color="#ff7f0e",
    label=labels[1],
    ecolor='#ff7f0e',
    elinewidth=2,
    capsize=5,
    marker='^',
    markersize=7
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_critic_mean),
    color="grey",
    linestyle="--",
    label=axlabel,
)

# Adding title and legend
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_31.pdf", bbox_inches="tight")
