# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "BEACH",
    "MOUNTAIN",
    "HISTORICAL SITES",
    "CITY TOURS",
    "ADVENTURE PARK",
]  # Capitalized category labels
means = [4.5, 4.2, 4.7, 4.3, 4.1]
errors = [0.3, 0.2, 0.4, 0.3, 0.2]
downerrors = [0.2, 0.1, 0.3, 0.2, 0.2]
legendtitles = ["Overall Average Rating", "Individual Category Mean"]
texttitle = "Overall Average Rating"
ylabel = "Average Rating"
xlabel = "Types of Tourist Attractions"
dataset_mean = 4.36
title = "Average Ratings of Different Tourist Attractions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 7))  # Adjusting figure size for clarity

# Custom color scheme
color = "teal"
error_color = "darkslateblue"

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="s",
    color=color,
    ecolor=error_color,
    capsize=5,
    markersize=8,
    markerfacecolor="white",
)

# Adding a legend with both "Overall Average Rating" and "Individual Category Mean"
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="s", color=color, ecolor=error_color, capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="gray", linestyle="--", linewidth=1.5
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=30)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_33.pdf", bbox_inches="tight")
