

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# example data for politics domain
x = np.array([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
y = 60 - 5 * np.log(x + 1)
xerr = 0.5
yerr = 5

# lower & upper limits of the error
lolims = np.array([0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0], dtype=bool)
uplims = np.array([1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1], dtype=bool)
ls = "None"
labels = [
    "Urban Voters",
    "Rural Voters",
    "Suburban Voters",
    "Young Voters",
    "Senior Voters"
]
title = "Approval Rating Trends Across Different Regions Over Time"
xlim = [0, 10.5]
xlabel = "Years Since Election"
ylabel = "Approval Rating (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4daf4a", "#ff7f00", "#377eb8", "#984ea3", "#e41a1c"]
fig, ax = plt.subplots(figsize=(10, 6))

# standard error bars
ax.errorbar(x, y, xerr=xerr, yerr=yerr, label=labels[0], linestyle='-', color=colors[0])
# including upper limits
ax.errorbar(
    x,
    y + 5,
    xerr=xerr,
    yerr=yerr,
    uplims=uplims,
    label=labels[1],
    linestyle='--',
    color=colors[1],
)

# including lower limits
ax.errorbar(
    x,
    y + 2,
    xerr=xerr,
    yerr=yerr,
    lolims=lolims,
    label=labels[2],
    linestyle='-.',
    color=colors[2],
)

# including upper and lower limits
ax.errorbar(
    x,
    y + 7,
    xerr=xerr,
    yerr=yerr,
    lolims=lolims,
    uplims=uplims,
    marker="o",
    markersize=8,
    label=labels[3],
    linestyle=':',
    color=colors[3],
)

# Plot a series with lower and upper limits in both x & y
# constant x-error with varying y-error
xerr = 0.5
yerr = np.full_like(x, 5)
yerr[[3, 6]] = 7

# mock up some limits by modifying previous data
xlolims = lolims
xuplims = uplims
lolims = np.zeros_like(x)
uplims = np.zeros_like(x)
lolims[[6]] = True  # only limited at this index
uplims[[3]] = True  # only limited at this index

# do the plotting
ax.errorbar(
    x,
    y + 10,
    xerr=xerr,
    yerr=yerr,
    xlolims=xlolims,
    xuplims=xuplims,
    uplims=uplims,
    lolims=lolims,
    marker="s",
    markersize=8,
    linestyle="none",
    label=labels[4],
    color=colors[4],
)

# tidy up the figure
ax.set_xlim(xlim)
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
plt.legend(bbox_to_anchor=(0.5, 1.15), ncol=5, loc="upper center")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_37.pdf", bbox_inches="tight")

