
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated legal data (e.g., Case Resolution Rates over 10 months)
months = np.arange(1, 11)
resolution_rate = np.array([75.0, 76.5, 77.0, 78.2, 79.1, 80.0, 80.5, 81.3, 82.0, 83.5])
resolution_rate_err = 1.5  # constant error
resolution_rate_err_varied = np.array([1.5, 1.2, 1.8, 1.5, 1.2, 2.1, 1.8, 1.5, 1.2, 1.8])

# upper & lower limits to simulate different scenarios
lower_limits = np.array([0, 1, 0, 1, 0, 1, 0, 0, 1, 0], dtype=bool)
upper_limits = np.array([1, 0, 1, 0, 1, 0, 0, 1, 0, 1], dtype=bool)
no_line = "None"
chart_title = "Case Resolution Rate with Error Limits"
x_axis_label = "Months"
y_axis_label = "Resolution Rate (%)"
xlim = [0, 11]
labels = [
    "Standard Error",
    "Upper Limits",
    "Lower Limits",
    "Both Limits",
    "Varied Error",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#377eb8", "#ff7f00", "#4daf4a", "#f781bf", "#a65628"]

fig, ax = plt.subplots(figsize=(10, 7))

# Standard error bars
ax.errorbar(months, resolution_rate, yerr=resolution_rate_err, label=labels[0], linestyle=no_line, color=colors[0])
# Including upper limits
ax.errorbar(
    months,
    resolution_rate + 2,
    yerr=resolution_rate_err,
    uplims=upper_limits,
    label=labels[1],
    linestyle=no_line,
    color=colors[1],
)
# Including lower limits
ax.errorbar(
    months,
    resolution_rate - 2,
    yerr=resolution_rate_err,
    lolims=lower_limits,
    label=labels[2],
    linestyle=no_line,
    color=colors[2],
)
# Including both upper and lower limits
ax.errorbar(
    months,
    resolution_rate + 3,
    yerr=resolution_rate_err,
    uplims=upper_limits,
    lolims=lower_limits,
    marker="o",
    markersize=8,
    label=labels[3],
    linestyle=no_line,
    color=colors[3],
)
# Varied error bars
ax.errorbar(
    months,
    resolution_rate + 4,
    yerr=resolution_rate_err_varied,
    xlolims=lower_limits,
    xuplims=upper_limits,
    marker="s",
    markersize=8,
    linestyle=no_line,
    label=labels[4],
    color=colors[4],
)

# Tidy up figure
ax.set_xlim(xlim)
ax.set_title(chart_title)
ax.set_xlabel(x_axis_label)
ax.set_ylabel(y_axis_label)
plt.legend(bbox_to_anchor=(0.5, 1.15), ncol=3, loc="upper center")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_38.pdf", bbox_inches="tight")
