
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# example data for growth rates of different civilizations
civilizations = np.arange(1, 11)
avg_growth_rates = np.random.uniform(1, 10, size=10)
error = np.random.uniform(0.1, 1, size=10)
lower_error = 0.5 * error
upper_error = error
asymmetric_error = [lower_error, upper_error]
title_sym = "Average Growth Rates with Symmetric Errors"
title_asym = "Average Growth Rates with Asymmetric Errors"
xlabel = "Civilizations"
ylabel = "Average Growth Rate (%)"
legend_sym = "Symmetric Error"
legend_asym = "Asymmetric Error"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

ax0.errorbar(civilizations, avg_growth_rates, yerr=error, fmt="o", color="#FF5733", 
             ecolor='#FFC300', elinewidth=1.5, capsize=4, label=legend_sym)
ax0.set_title(title_sym)
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel)
ax0.legend()

ax1.errorbar(civilizations, avg_growth_rates, xerr=asymmetric_error, fmt="o", color="#3498DB", 
             ecolor='#85C1E9', elinewidth=1.5, capsize=4, label=legend_asym)
ax1.set_title(title_asym)
ax1.set_xlabel(xlabel)
ax1.set_yscale("log")
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_40.pdf", bbox_inches="tight")
