

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Changed seed for a different random sequence

# example data
x = np.arange(0.1, 4, 0.5)
saturation = np.sin(x) * 0.8 + 0.5  # Generating saturation data
hue_shift = np.cos(x) * 0.6  # Generating hue shift data
saturation_error = 0.04 + 0.08 * x
hue_shift_error = 0.08 + 0.1 * x
saturation_asymmetric_error = [0.2 * saturation_error, saturation_error]
hue_shift_asymmetric_error = [0.3 * hue_shift_error, hue_shift_error]

# Labels and titles
title_saturation = "Color Saturation Variation with Symmetric Error"
title_hue_shift = "Hue Shift Variation with Asymmetric Error"
xlabel = "Time (s)"
ylabel_saturation = "Saturation (units)"
ylabel_hue_shift = "Hue Shift (units)"
legendlabels = ["Saturation", "Hue Shift"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Saturation plot with symmetric error
ax0.errorbar(x, saturation, yerr=saturation_error, fmt="D", color="#1f77b4", ecolor="#ff7f0e", elinewidth=2, capsize=3, label=legendlabels[0])
ax0.set_title(title_saturation)
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel_saturation)
ax0.legend()

# Hue Shift plot with asymmetric error
ax1.errorbar(x, hue_shift, xerr=hue_shift_asymmetric_error, fmt="*", color="#d62728", ecolor="#9467bd", elinewidth=2, capsize=3, label=legendlabels[1])
ax1.set_title(title_hue_shift)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel_hue_shift)
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_41.pdf", bbox_inches="tight")

