

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New dataset related to education (e.g., average scores over 10 exams)
exams = np.linspace(1, 10, 10)
average_scores = np.random.uniform(70, 95, 10)
upper_error_scores = np.random.uniform(2, 5, 10)  # Upper error margin
lower_error_scores = np.random.uniform(1, 3, 10)  # Lower error margin
left_error_exams = [0.1] * 10
right_error_exams = [0.2] * 10
title = "Average Exam Scores with Asymmetric Error"
xlabel = "Exams"
ylabel = "Average Scores"
label = "Exam Score Errorbar"
annotation_text = "Avg Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))
ax.errorbar(
    exams,
    average_scores,
    xerr=[left_error_exams, right_error_exams],
    yerr=[lower_error_scores, upper_error_scores],
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    elinewidth=2,
    capsize=4,
    label=label,
    markersize=7,
    markerfacecolor="#2ca02c",
    markeredgewidth=2,
    markeredgecolor="#d62728"
)

# Adding text annotations for upper and lower errors
for i, (d, score, uerr, lerr) in enumerate(zip(exams, average_scores, upper_error_scores, lower_error_scores)):
    ax.text(
        d + 0.3, score + 0.5 * uerr, f"+{uerr:.2f}", va="center", ha="center", fontsize=10, color="#000000"
    )
    ax.text(
        d + 0.3, score - 0.5 * lerr, f"-{lerr:.2f}", va="center", ha="center", fontsize=10, color="#000000"
    )

# Customizing the plot
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.legend(fontsize=12)
ax.grid(True, linestyle='--', linewidth=0.5)
ax.axhline(np.mean(average_scores), color="gray", linestyle="--", linewidth=1.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_42.pdf", bbox_inches="tight")

