

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

x = np.linspace(2000, 2009, 10)
y = np.random.uniform(1000, 2000, 10)
upper_error = np.random.uniform(50, 100, 10)
down_error = np.random.uniform(50, 100, 10)
left_error = [0.1] * 10
right_error = [0.2] * 10
title = "Population Growth Measurements with Asymmetric Errors"
xlabel = "Year"
ylabel = "Population (in thousands)"
xhline = 1500
label = "Population"
legendlabels = ["Measurement Error", "Threshold (1500)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    x,
    y,
    xerr=[left_error, right_error],
    yerr=[down_error, upper_error],
    fmt="o",
    color="#0077b6",
    ecolor="#009688",
    elinewidth=2,
    capsize=5,
    label=label,
)
for i, (xi, yi, uperror, downerror) in enumerate(zip(x, y, upper_error, down_error)):
    ax.text(
        xi + 0.3, yi + 0.5 * uperror, r"${+%.2f}$" % (uperror), va="center", ha="center"
    )
    ax.text(
        xi + 0.3,
        yi - 0.5 * downerror,
        r"${-%.2f}$" % (downerror),
        va="center",
        ha="center",
    )
ax.set_title(title, fontsize=16)
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.legend(fontsize=12)
ax.axhline(xhline, color="r", linestyle="--", linewidth=1.5)
ax.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_44.pdf", bbox_inches="tight")

