

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Generating data for the tourism domain
tourist_attractions = np.linspace(1, 10, 10)  # Tourist attractions numbered from 1 to 10
average_visitors = np.random.uniform(500, 1500, 10)  # Average visitors between 500 to 1500
left_error = np.random.uniform(50, 150, 10)  # Error values (lower bound)
right_error = np.random.uniform(50, 150, 10)  # Error values (upper bound)

title = "Average Number of Visitors to Different Tourist Attractions"
xlabel = "Tourist Attraction"
ylabel = "Average Number of Visitors"
legend_label = "Visitors with Error"
annotation_texts = ["L", "R"]  # Labels for left and right error

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    tourist_attractions,
    average_visitors,
    xerr=[left_error, right_error],
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    elinewidth=1.5,
    capsize=3,
    capthick=1.5,
    label=legend_label,
)
for i, (ta, visitors, le, re) in enumerate(zip(tourist_attractions, average_visitors, left_error, right_error)):
    ax.text(
        ta - 0.8 * le, 
        visitors + 10, 
        r"${-%d}$" % (le), 
        va="center", 
        ha="center",
        fontsize=8,
        color="green"
    )
    ax.text(
        ta + 0.8 * re, 
        visitors + 10, 
        r"${+%d}$" % (re), 
        va="center", 
        ha="center",
        fontsize=8,
        color="red"
    )

# Set chart title and labels
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc="upper left", fontsize=10)
ax.xaxis.grid(True)
ax.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_46.pdf", bbox_inches="tight")

