
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42) 
# New data context: Crop Yield, Area Cultivated, Average Rainfall over 6 years
years = np.arange(2015, 2021)

crop_yield = np.random.uniform(2, 5, 6)  # in tons per acre
area_cultivated = np.random.uniform(50, 100, 6)  # in hectares
average_rainfall = np.random.uniform(400, 800, 6)  # in millimeters

yield_error = [np.random.uniform(0.1, 0.5, 6), np.random.uniform(0.1, 0.5, 6)]
area_error = [np.random.uniform(5, 10, 6), np.random.uniform(5, 10, 6)]
rainfall_error = np.random.uniform(20, 50, 6)

title = "Agricultural Trends Over Years"
xvline = 2018
ylabel_yield = "Crop Yield (tons/acre)"
ylabel_area = "Area Cultivated (hectares)"
ylabel_rainfall = "Average Rainfall (mm)"

legend_label = 'Average Rainfall'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 10), nrows=3, sharex=True)

colors = ["#2b83ba", "#abdda4", "#fdae61", "#d7191c", "#2c7bb6", "#fdae61"]

# Crop Yield subplot with symmetric vertical error bars
for i in range(len(years)):
    ax0.errorbar(
        years[i],
        crop_yield[i],
        yerr=[[yield_error[0][i]], [yield_error[1][i]]],
        fmt="o",
        color=colors[i],
        capsize=4,
    )
    ax0.text(years[i] - 0.2, crop_yield[i] + 0.1, f"{crop_yield[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(title)
ax0.set_ylabel(ylabel_yield)
ax0.axhline(y=3.5, linestyle="--", color="#555555")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Area Cultivated subplot with symmetric horizontal error bars
for i in range(len(years)):
    ax1.errorbar(
        years[i],
        area_cultivated[i],
        xerr=[[area_error[0][i]], [area_error[1][i]]],
        fmt="o",
        color=colors[i],
        markersize=8,
    )
    ax1.text(years[i] + 0.1, area_cultivated[i] + 1, f"{area_cultivated[i]:.2f}", fontsize=8, ha="left")
ax1.set_title(title)
ax1.set_ylabel(ylabel_area)
ax1.axvline(x=xvline, linestyle="--", color="#555555")
ax1.xaxis.grid(True)
ax1.yaxis.grid(False)

# Average Rainfall subplot with symmetric vertical error bars
ax2.errorbar(years, average_rainfall, yerr=rainfall_error, fmt="*", color="#444444", capsize=2)
ax2.set_title(title)
ax2.set_ylabel(ylabel_rainfall)
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)
ax2.legend([legend_label])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_50.pdf", bbox_inches="tight")
