
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
categories = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
]

means = np.random.uniform(20, 100, len(categories))
std_devs = np.random.uniform(5, 15, len(categories))
dataset_mean = np.mean(means)

# Labels and Plot Types
label_Mean = "Mean AQI"
label_Dataset_mean = "Average AQI"

# Axes Limits and Labels
ylabel_value = "AQI Value"
title = "Air Quality Index (AQI) by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
ylim_values = [0.0, 120]
# Error bar plot with optimized style
ax.errorbar(
    categories,
    means,
    yerr=std_devs,
    fmt="o",
    color="blue",
    ecolor="green",
    elinewidth=2,
    capsize=5,
    markerfacecolor="lightblue",
    label=label_Mean,
)

# Dataset mean line
ax.axhline(
    y=dataset_mean,
    color="darkorange",
    linestyle="--",
    linewidth=1.5,
    label=label_Dataset_mean,
)

# Customizing the plot
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=10)
ax.legend(fontsize=10)
ax.set_ylim(ylim_values)

# Title for the plot
ax.set_title(title, fontsize=14, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_51.pdf", bbox_inches="tight")

