

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
categories = [
    "Heart Rate",
    "Blood Pressure",
    "Cholesterol Levels",
    "BMI",
    "Respiratory Rate",
    "Blood Sugar Levels",
]

means = np.random.uniform(60, 140, len(categories))
std_devs = np.random.uniform(10, 20, len(categories))
dataset_mean = np.mean(means)

# Labels and Plot Types
label_Mean = "Mean Health Metric"
label_Dataset_mean = "Average Health Metric"

# Axes Limits and Labels
ylabel_value = "Score (0-200)"


title = "Cardiovascular Health Metrics Assessment"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
ylim_values = [0, 200]
# Error bar plot with optimized style
ax.errorbar(
    categories,
    means,
    yerr=std_devs,
    fmt="o",
    color="#1f77b4",         # Blue marker color
    ecolor="#2ca02c",        # Green error bar color
    elinewidth=2,
    capsize=5,
    markerfacecolor="#ff7f0e",  # Orange marker face color
    label=label_Mean,
)

# Dataset mean line
ax.axhline(
    y=dataset_mean,
    color="#d62728",         # Red color
    linestyle="--",
    linewidth=1.5,
    label=label_Dataset_mean,
)

# Customizing the plot
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=10)
ax.legend(fontsize=10)
ax.set_ylim(ylim_values)

# Title for the plot
ax.set_title(title, fontsize=14, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_53.pdf", bbox_inches="tight")

