

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
categories = ["Watching TV", "Reading", "Gaming", "Social Media", "Exercise"]
average_time = [3.5, 1.2, 2.8, 2.5, 1.0]  # Average time spent in hours per day
errors = [0.5, 0.4, 0.3, 0.2, 0.6]  # Time variance
world_mean = [2.2]  # Global average time spent on leisure activities per day
xlabel = "Average Time Spent per Day (hours)"
label = "Global Average Time Spent"
plot_title = 'Average Time Spent on Leisure Activities'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    average_time,
    categories,
    xerr=errors,
    fmt="o",
    color="#0077b6",
    ecolor="#48cae4",
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label="Activity Type Mean",
)
plt.axvline(world_mean[0], color="#f77f00", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle=':', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_54.pdf", bbox_inches="tight")
